/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Jasmine 11/23/06 GET_SETTING_FROM_PARA_SETTING_DLG							*
 * Jasmine 03/27/06 DLG_RESIZE_PAINT_MESS										*
 *	ML 11/7/2007 MORE_LOCALIZATION_WORK											*
 * Jasmine 07/08/08 QA80-9434 DEFINE_PEAK_FUNC_IN_FO							*
 *	Kyle 07/28/08 ADD_PEAK_FUNC_HINTS_IN_DLG									*
 *	Kyle 11/04/2008 USE_NEW_NLFSESSION_AND_GRIDCONTROL_FOR_FO_PARAMS_SETTING	*
 *	Kyle 11/06/2008 SET_DIALOG_NAME_FOR_REGISTRY								*
 *	Kyle 11/06/2008 MERGE_TWO_TABS_TO_ONE_AND_NOT_SHOW_SHORT_CUT_MENU			*
 *	Kyle 01/14/2009 SUPPORT_DOUBLE_CLICK_TO_SWICH_BOUND_CONTROL					*
 *	Kyle 01/15/2009 SETFUNCTION_ADD_ARGUMENT_TO_OUTPUT_ERROR_CODE				*
 *	Kyle 01/19/2009 USE_COLORTEXT_FOR_THE_PEAK_FUNC_HINTS_TO_SHOW_RED_ERROR_MESSAGE
 *	Kyle 04/01/2009 SHOW_TOOLTIP_WHEN_MOUSE_MOVED_ON_BOUNDS_CONTROL				*
 *	Jasmine 07/20/10 ORG-486-P2 MAKE_SURE_PEAK_FUNCTION_IS_CORRECT				*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
#include "DialogEx.h"

#define _NLF_81(_NAME) //CPY 11/04/08 temp_adding_here_to_allow_compiling NLFPParamsControl.h

//#define WM_USER_NLF_ON_PARAM_CHANGE	(WM_USER + 1010)
#define WPARAM_PARAM_CHANGE_BY_USER			0x1000
///Kyle 11/04/2008 USE_NEW_NLFSESSION_AND_GRIDCONTROL_FOR_FO_PARAMS_SETTING
//#include "NLFitParaControl.h"
//#include "NLFitSession.h"
#include <event_utils.h>
#include "NLFitSession.h"
#include "GridTableControl.h"
#include "NLFitParaControl.h"
///End USE_NEW_NLFSESSION_AND_GRIDCONTROL_FOR_FO_PARAMS_SETTING
#include "FOParametersSetting.h"

#define STR_DIALOG_REGIRTRY_NAME		"FO Parameter Settings"				///Kyle 11/06/2008 SET_DIALOG_NAME_FOR_REGISTRY


class NLParamBoundsDlg : public ResizeDialog
{
public:
	NLParamBoundsDlg(TreeNode &trFuncDetail, TreeNode& trPeakFunc) : ResizeDialog(IDD_NL_PARA_BOUNDS_DLG, "ODlg8")
	{
		///Kyle 01/15/2009 SETFUNCTION_ADD_ARGUMENT_TO_OUTPUT_ERROR_CODE
		//m_GridParas.SetTree(trFuncDetail);
		int nErrorCode;
		if(!m_GridParas.SetTree(trFuncDetail, &nErrorCode))
		{
			m_bShowErrMsg = true;
			ocu_load_msg_str(nErrorCode, &m_strErrMsg);
		}
		else
			m_bShowErrMsg = false;
		///End SETFUNCTION_ADD_ARGUMENT_TO_OUTPUT_ERROR_CODE
		m_trPeakFunc = trPeakFunc;			///Jasmine 07/08/08 QA80-9434 DEFINE_PEAK_FUNC_IN_FO
		if( !m_trPeakFunc.IsValid() )
			error_report("m_trPeakFunc is invalid");
	}	
	~NLParamBoundsDlg()
	{
	}
	int  DoModalEx(HWND hParent = NULL) 
	{
		InitMsgMap();
		//int nRet = ResizeDialog::DoModal(hParent);
		int nRet = DoModal(hParent);
		
		return nRet;
	}
	virtual int  Create(HWND hParent = NULL)
	{
		InitMsgMap();
		//Launch the modeless dialog
		int nRet = ResizeDialog::Create(hParent);
		Visible=true;
		
		return nRet;
	}	
	
protected:
	
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_SIZE(OnDlgResize)
	ON_DESTROY(OnDestroy)				/// Kyle 11/06/2008 SET_DIALOG_NAME_FOR_REGISTRY
	
	ON_INIT_SIZE(OnInitSize)	
	ON_RESTORESIZE(OnRestoreSize)
	
	ON_OK(OnOk)
	ON_CANCEL(OnClickCancel)
	ON_TAB_SEL_CHANGE(IDC_NL_PARA_SETTING_TAB, OnTabChange)
	
	//--- vsFlex realted
	ON_GRID_BEFORE_EDIT(IDC_PARA_BOUNDS_LIST, OnBeforeEditParaControl)
	ON_GRID_AFTER_EDIT(IDC_PARA_BOUNDS_LIST, OnAfterEditParaControl)
	//ON_GRID_BEFORE_MOUSE_DOWN(IDC_PARA_BOUNDS_LIST, OnBeforeMouseDownParaControl)			///Kyle 11/06/2008 MERGE_TWO_TABS_TO_ONE_AND_NOT_SHOW_SHORT_CUT_MENU
	ON_GRID_MOUSE_MOVE(IDC_PARA_BOUNDS_LIST, OnMouseMoveParaControl)
	//---
	
	ON_BN_CLICKED(IDC_PEAK_FUNC_CHECK, OnPeakFuncCheck)	///Jasmine 07/08/08 QA80-9434 DEFINE_PEAK_FUNC_IN_FO
	
	///Kyle 01/14/2009 SUPPORT_DOUBLE_CLICK_TO_SWICH_BOUND_CONTROL
	//ON_GRID_BUTTON_CLICK(IDC_PARA_BOUNDS_LIST, OnGridButtonClick)			/// Kyle 11/04/2008 USE_NEW_NLFSESSION_AND_GRIDCONTROL_FOR_FO_PARAMS_SETTING
	ON_GRID_DBLCLICK(IDC_PARA_BOUNDS_LIST, OnGridDBClick)
	///End SUPPORT_DOUBLE_CLICK_TO_SWICH_BOUND_CONTROL

EVENTS_END

//------------ Event Handlers ------------------------
	///Kyle 01/14/2009 SUPPORT_DOUBLE_CLICK_TO_SWICH_BOUND_CONTROL
	/////Kyle 11/04/2008 USE_NEW_NLFSESSION_AND_GRIDCONTROL_FOR_FO_PARAMS_SETTING
	//void OnGridButtonClick(Control flxControl, int nRow, int nCol)
	//{
		//m_GridParas.OnButtonClick( flxControl, nRow, nCol );
		//if( NLPARAMGRIDCOLTYPE_LB_CONTROL == nCol || NLPARAMGRIDCOLTYPE_UB_CONTROL == nCol )
			//OnAfterEditParaControl( flxControl, nRow, nCol );
	//}
	/////End USE_NEW_NLFSESSION_AND_GRIDCONTROL_FOR_FO_PARAMS_SETTING
	void OnGridDBClick(Control flxControl)
	{
		int nRow = 0, nCol = 0;
		int nx = -1, ny = -1;
		m_GridParas.GetSelCell(nx, ny, nRow, nCol);
		if( NLPARAMGRIDCOLTYPE_LB_CONTROL == nCol || NLPARAMGRIDCOLTYPE_UB_CONTROL == nCol )
		{
			m_GridParas.OnButtonClick( flxControl, nRow, nCol );
			OnAfterEditParaControl( flxControl, nRow, nCol )
		}
	}
	///End SUPPORT_DOUBLE_CLICK_TO_SWICH_BOUND_CONTROL

	BOOL OnInitDialog()
	{
		//waitCursor junk;
		///Kyle 11/06/2008 SET_DIALOG_NAME_FOR_REGISTRY
		//ResizeDialog::OnInitDialog(0, STR_DLG_NAME);		
		ResizeDialog::OnInitDialog(0, STR_DIALOG_REGIRTRY_NAME);		
		///End SET_DIALOG_NAME_FOR_REGISTRY
    	InitGridParas();
	    SetInitReady();
		m_tabSettings = GetItem(IDC_NL_PARA_SETTING_TAB);
		/// Hong 11/06/07 v8.0741 MORE_LOCALIZATION
		//m_tabSettings.InsertItem(NLF_NORMAL_SETTING_TAB,"Parameters");
		//m_tabSettings.InsertItem(NLF_PBOUND_SETTING_TAB,"Bounds");
		//Text = STR_DLG_NAME;
		m_tabSettings.InsertItem(NLF_NORMAL_SETTING_TAB,_L("Parameters"));
		///Kyle 11/06/2008 MERGE_TWO_TABS_TO_ONE_AND_NOT_SHOW_SHORT_CUT_MENU
		//m_tabSettings.InsertItem(NLF_PBOUND_SETTING_TAB,_L("Bounds"));
		///End MERGE_TWO_TABS_TO_ONE_AND_NOT_SHOW_SHORT_CUT_MENU
		/// ML 11/7/2007 MORE_LOCALIZATION_WORK
		//Text = GetLocalized(STR_DLG_NAME);
		Text = STR_DLG_NAME;
		/// end MORE_LOCALIZATION_WORK
		/// end MORE_LOCALIZATION
		
		//GetItem(IDC_PEAK_FUNC_HINTS).Visible = false;	///Jasmine 07/08/08 QA80-9434 DEFINE_PEAK_FUNC_IN_FO
		///Kyle 01/19/2009 USE_COLORTEXT_FOR_THE_PEAK_FUNC_HINTS_TO_SHOW_RED_ERROR_MESSAGE
		//m_ctrlPeakFuncHints = GetItem(IDC_PEAK_FUNC_HINTS);		///Kyle 07/28/08 ADD_PEAK_FUNC_HINTS_IN_DLG
		Control cn = GetDlgItem(IDC_PEAK_FUNC_HINTS);
		if(cn)
			m_ctrlPeakFuncHints.CreateControl(cn.GetSafeHwnd());
		///End USE_COLORTEXT_FOR_THE_PEAK_FUNC_HINTS_TO_SHOW_RED_ERROR_MESSAGE
    		   
		RECT rr;
		m_tabSettings.GetItemRect(0,&rr);rr.bottom += 10;
		m_tabSettings.MoveWindow(&rr);// no need to worry about width, it will be resized later
		
		Control cntl;
		OnTabChange(cntl);
		
		initPeakFuncCheck(IDC_PEAK_FUNC_CHECK);	///Jasmine 07/08/08 QA80-9434 DEFINE_PEAK_FUNC_IN_FO		

		checkShowErrorMsg();				///Kyle 01/15/2009 SETFUNCTION_ADD_ARGUMENT_TO_OUTPUT_ERROR_CODE

		return true;
	}		
	BOOL OnDlgResize(int nType, int cx, int cy)
	{
		if(!IsInitReady())
			return TRUE;
		///Jasmine 03/27/06 DLG_RESIZE_PAINT_MESS
		MoveControlsHelper	_temp(this);	
		_temp.Exclude(IDC_NL_PARA_SETTING_TAB);
		///End DLG_RESIZE_PAINT_MESS
		uint nButtonIDs[] = {IDCANCEL, IDOK, 0};
		//ArrangeMainItemAndControls(nButtonIDs, IDC_PARA_BOUNDS_LIST, NULL, false);
		ArrangeMainItemAndControls(nButtonIDs, IDC_NL_PARA_SETTING_TAB, NULL, false);
		RECT rect;
		m_tabSettings.GetWindowRect(&rect);
		ScreenToClient(&rect);
		///Kyle 07/28/08 ADD_PEAK_FUNC_HINTS_IN_DLG
		int nErrMessage = GetPeakFuncHingsHeight( RECT_WIDTH(rect) );
		if(nErrMessage>0)
		{
			RECT rrtmp;
			GetClientRect(m_chkPeak, rrtmp);
			rect.bottom -= ( nErrMessage + RECT_HEIGHT(rrtmp) + 2*GetControlGap() );
			m_tabSettings.MoveWindow(&rect);
			//m_tabSettings.AdjustRect(FALSE, &rect);
		}
		///End ADD_PEAK_FUNC_HINTS_IN_DLG
		
		m_tabSettings.AdjustRect(FALSE, &rect);		///Kyle 07/28/08 ADD_PEAK_FUNC_HINTS_IN_DLG
		
		Control cBox=GetItem(IDC_PARA_BOUNDS_LIST);
		cBox.MoveWindow(&rect);
		
		///Jasmine 07/08/08 QA80-9434 DEFINE_PEAK_FUNC_IN_FO		
		GetClientRect(m_tabSettings, rect);	
		
		RECT 	rrCheck;
		GetClientRect(m_chkPeak, rrCheck);			
		int nWidth 	= RECT_WIDTH(rrCheck);
		int nHeight = RECT_HEIGHT(rrCheck);
		
		rrCheck.left 	= GetControlGap();
		rrCheck.right 	= rrCheck.left + nWidth;
		rrCheck.top 	= rect.bottom + GetControlGap();
		rrCheck.bottom 	= rrCheck.top + nHeight;
		MoveControl(m_chkPeak, rrCheck);
		///End DEFINE_PEAK_FUNC_IN_FO
		///Kyle 07/28/08 ADD_PEAK_FUNC_HINTS_IN_DLG
		if(nErrMessage>0)
		{
			m_ctrlPeakFuncHints.Visible = true;
			RECT rrHints;
			rrHints.left 	= GetControlGap();
			rrHints.right 	= rect.right;
			rrHints.top 	= rrCheck.bottom + GetControlGap();
			rrHints.bottom 	= rrHints.top + nErrMessage;
			MoveControl(m_ctrlPeakFuncHints, rrHints);
		}
		else
			m_ctrlPeakFuncHints.Visible = false;
		///End ADD_PEAK_FUNC_HINTS_IN_DLG
		return TRUE;
	}	
	BOOL	OnInitSize()
	{
		return FALSE;
	}
	BOOL	OnRestoreSize(DWORD dwSizeInfo)
	{
		void * p = (void*)dwSizeInfo;
		DLGSIZEINFO *pSz = (DLGSIZEINFO*)p;
		///Kyle 11/06/2008 SET_DIALOG_NAME_FOR_REGISTRY
		//lstrcpyn(pSz->szDialogName, STR_DLG_NAME, MAXLINE);
		lstrcpyn(pSz->szDialogName, STR_DIALOG_REGIRTRY_NAME, MAXLINE);
		///End SET_DIALOG_NAME_FOR_REGISTRY
				
		pSz->top = -1;
		pSz->left = - 1;
		pSz->width = 500;
		pSz->height = 350;
		
		return TRUE;
	}	
	BOOL OnOk()
	{
		///Jasmine 07/20/10 ORG-486-P2 MAKE_SURE_PEAK_FUNCTION_IS_CORRECT
		if(m_chkPeak.Check)
		{
			Tree trTest;
			GetTree(trTest);
			
			if( !peak_fit_is_peak_func(trTest) )
			{
				ASSERT(lstrlen(m_ctrlPeakFuncHints.Text) > 0);
				MessageBox(GetSafeHwnd(), m_ctrlPeakFuncHints.Text);
				
				return FALSE;
			}
		}
		///End MAKE_SURE_PEAK_FUNCTION_IS_CORRECT
		m_trPeakFunc.nVal = m_chkPeak.Check;		///Jasmine 07/08/08 QA80-9434 DEFINE_PEAK_FUNC_IN_FO
		///Kyle 11/04/2008 USE_NEW_NLFSESSION_AND_GRIDCONTROL_FOR_FO_PARAMS_SETTING
		//m_GridParas.updateFitSessionParamsTreeFromGrid();
		///End USE_NEW_NLFSESSION_AND_GRIDCONTROL_FOR_FO_PARAMS_SETTING
		OnDestroy();
		return TRUE;
	}
	BOOL OnClickCancel()
	{
		return true;
	}
	BOOL	OnTabChange(Control cntrl)
	{
		int nSelTab=m_tabSettings.GetCurSel();
		return m_GridParas.ShowSettings(nSelTab);
	}
	void  OnAfterEditParaControl(Control flxControl, int nRow, int nCol)
	{
		m_GridParas.OnAfterEdit(flxControl, nRow, nCol);
	}
	
	void  OnBeforeEditParaControl(Control flxControl, long nRow, long nCol, BOOL* pCancel)
	{
		m_GridParas.OnBeforeEditParaControl(flxControl, nRow, nCol,pCancel );
	}
	///Kyle 11/06/2008 MERGE_TWO_TABS_TO_ONE_AND_NOT_SHOW_SHORT_CUT_MENU
	//void  OnBeforeMouseDownParaControl(Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel)
	//{
		//m_GridParas.OnBeforeMouseDown(cntrl, nButton, nShift, X, Y, pCancel);
	//}
	///End MERGE_TWO_TABS_TO_ONE_AND_NOT_SHOW_SHORT_CUT_MENU
	void  OnMouseMoveParaControl(Control cntrl, short nButton, short nShift, float X, float Y)
	{
		//m_GridParas.OnMouseMove(cntrl, nButton, nShift, X, Y);			///Kyle 11/04/2008 USE_NEW_NLFSESSION_AND_GRIDCONTROL_FOR_FO_PARAMS_SETTING
		///Kyle 04/01/2009 SHOW_TOOLTIP_WHEN_MOUSE_MOVED_ON_BOUNDS_CONTROL
		m_GridParas.OnMouseMove(cntrl, nButton, nShift, X, Y);
		///End SHOW_TOOLTIP_WHEN_MOUSE_MOVED_ON_BOUNDS_CONTROL
	}
	///Jasmine 07/08/08 QA80-9434 DEFINE_PEAK_FUNC_IN_FO
	BOOL OnPeakFuncCheck(Control ctrl)
	{
		///Kyle 01/15/2009 SETFUNCTION_ADD_ARGUMENT_TO_OUTPUT_ERROR_CODE
		if(m_bShowErrMsg)
			return false;
		///End SETFUNCTION_ADD_ARGUMENT_TO_OUTPUT_ERROR_CODE
		bool bPeakFunc = m_chkPeak.Check;
	
		m_GridParas.OnPeakFuncCheck(bPeakFunc);
		
		if(bPeakFunc)
		{
			if( m_strHints.IsEmpty() )
			{
				ocu_load_err_msg_str(FO_PEAK_FUNC_MSG, &m_strHints);	
				m_strHints += "\r\n\r\n" + _L("Please assign these attributes from the drop-down list on the Peak Attributes column.");///Jasmine 07/14/10 ORG-540-P3
			}
			m_ctrlPeakFuncHints.Text = m_strHints;
		}
		else
			m_ctrlPeakFuncHints.Text = "";
		
		OnDlgResize(0, 0, 0);
		return TRUE;
	}
	///End DEFINE_PEAK_FUNC_IN_FO
public:
	void	GetTree(TreeNode &trFunctDail)
	{
		m_GridParas.GetTree(trFunctDail);
	}
protected:
	BOOL OnDestroy()
	{
		m_GridParas.OnDestroy();
		return ResizeDialog::OnDestroy();
	}
private:
	///Kyle 01/15/2009 SETFUNCTION_ADD_ARGUMENT_TO_OUTPUT_ERROR_CODE
	void checkShowErrorMsg()
	{
		if(!m_bShowErrMsg)
			return;
		Control ctrlOK = GetItem(IDOK);
		if(ctrlOK)
			ctrlOK.Enable = false;
		if(m_chkPeak)
			m_chkPeak.Enable = false;
		if(m_ctrlPeakFuncHints)
		{
			m_ctrlPeakFuncHints.Text = m_strErrMsg;
			m_ctrlPeakFuncHints.SetTxtColor(color_index_to_rgb(SYSCOLOR_RED));		///Kyle 01/19/2009 USE_COLORTEXT_FOR_THE_PEAK_FUNC_HINTS_TO_SHOW_RED_ERROR_MESSAGE
		}
	}
	///End SETFUNCTION_ADD_ARGUMENT_TO_OUTPUT_ERROR_CODE
	///Kyle 07/28/08 ADD_PEAK_FUNC_HINTS_IN_DLG 
	int GetPeakFuncHingsHeight(int nMsgBoxWidth)
	{
		string str = m_ctrlPeakFuncHints.Text;
		int nW = nMsgBoxWidth;
		int nHeight = m_ctrlPeakFuncHints.Measure(str, &nW);
		return nHeight;
	}
	///End ADD_PEAK_FUNC_HINTS_IN_DLG
	///Jasmine 07/08/08 QA80-9434 DEFINE_PEAK_FUNC_IN_FO
	void initPeakFuncCheck(int nID)
	{
		m_chkPeak = GetItem(nID);
		m_chkPeak.Text = GetLocalized(STR_PEAK_FUNC_CHECK_E);			
		m_chkPeak.Enable = ENABLE == m_trPeakFunc.Enable;
		m_chkPeak.Check = m_trPeakFunc.nVal;
		
		OnPeakFuncCheck(m_chkPeak);
	}
	///End DEFINE_PEAK_FUNC_IN_FO
	void InitGridParas()
	{
		///Kyle 11/06/2008 SET_DIALOG_NAME_FOR_REGISTRY
		//m_GridParas.Init(IDC_PARA_BOUNDS_LIST, *this, STR_DLG_NAME);
		m_GridParas.Init(IDC_PARA_BOUNDS_LIST, *this, STR_DIALOG_REGIRTRY_NAME);
		///End SET_DIALOG_NAME_FOR_REGISTRY
		
		m_GridParas.Update();
	}
	void	ShownControlToTopTab()
	{
		RECT rTab;
		GetClientRect(m_tabSettings, rTab);
		int nEdge=GetControlGap(), cx=rTab.right;

		m_tabSettings.AdjustRect(FALSE, &rTab);
	
		RECT rBox;
		rBox=rTab;
		Control cBox=GetItem(IDC_NLF_BOX);
		MoveControl(cBox, rBox);
	}
private:
	FOParamSetting					m_GridParas;
	TabControl 						m_tabSettings;
	Button							m_chkPeak;		///Jasmine 07/08/08 QA80-9434 DEFINE_PEAK_FUNC_IN_FO
	TreeNode						m_trPeakFunc;	
	///Kyle 01/19/2009 USE_COLORTEXT_FOR_THE_PEAK_FUNC_HINTS_TO_SHOW_RED_ERROR_MESSAGE
	//Control 						m_ctrlPeakFuncHints;	///Kyle 07/28/08 ADD_PEAK_FUNC_HINTS_IN_DLG
	ColorText						m_ctrlPeakFuncHints;
	///End USE_COLORTEXT_FOR_THE_PEAK_FUNC_HINTS_TO_SHOW_RED_ERROR_MESSAGE
	
	string							m_strHints;
	///Kyle 01/15/2009 SETFUNCTION_ADD_ARGUMENT_TO_OUTPUT_ERROR_CODE
	bool 							m_bShowErrMsg;
	string 							m_strErrMsg;
	///End SETFUNCTION_ADD_ARGUMENT_TO_OUTPUT_ERROR_CODE
};



void OpenDlg()
{
	NLParamBoundsDlg  NLPB;
	
	Window winDlg = NLPB.GetWindow();
	if(winDlg)
	{
		out_str("Project Browser Dialog already open");
	}
	int nRet=NLPB.DoModal( NULL ); 
}
//BOOL FOParametersSetting(TreeNode &trFunctDail, DWORD dwOption = 0, HWND hParent = NULL)///Jasmine 07/08/08 QA80-9434 DEFINE_PEAK_FUNC_IN_FO
BOOL FOParametersSetting(TreeNode &trFunctDail, TreeNode& trPeakFunc, DWORD dwOption = 0, HWND hParent = NULL)
{
	NLParamBoundsDlg  NLPB(trFunctDail, trPeakFunc);
	
	Window winExDlg = NLPB.GetWindow();
	if(winExDlg)
	{
		out_str("Project Browser Dialog already open");
		return false;
	}
	Window winNewDlg(hParent);
	HWND hWnd = GetWindow();
	if(winNewDlg)
		hWnd = hParent;
		 
	int nRet=NLPB.DoModalEx( hWnd ); 
	///Jasmine 11/23/06 GET_SETTING_FROM_PARA_SETTING_DLG
	//if cancel, don't update FO
	if(nRet != IDCANCEL)
	{
		NLPB.GetTree(trFunctDail);
		return true;
	}
	return false;
	///End GET_SETTING_FROM_PARA_SETTING_DLG
}
